#!/bin/sh

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# JaDOrT: JASMINe Deployment Orchestration Tool
# Copyright (C) 2008 Bull S.A.S.
# Copyright (C) 2008 France Telecom R&D
# Contact: jasmine@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# $Id: stop.sh 2914 2008-12-18 12:44:59Z alitokmen $
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

export JONAS_TAR_GZ_LOCATION=~

pushd $JONAS_TAR_GZ_LOCATION

servers=
while [ "$#" -gt 0 ]
do
	servers="$servers $1"
	shift
done

if [ "" = "$servers" ]
then
	echo "Enter JOnAS server numbers, separated by a space"
	read servers
fi

for jonas in $servers
do
	export JONAS_ROOT=$PWD/jadort-samples-launcher/root
	export JONAS_BASE=$PWD/jadort-samples-launcher/$jonas
	$JONAS_ROOT/bin/jonas halt -n jonas$jonas -Ddomain.name=jonas
done

popd
